import React from "react";
import Link from "next/link";

function Navbar() {
  return (
    <nav className="flex items-center justify-between flex-wrap bg-blue-800 p-4 w-full">
      <div className="items-center text-white">
        <span className="font-semibold text-2xl"> WallerudTech Golf</span>
      </div>

      <div className="flex-grow flex items-center w-auto">
        <div className="text-sm flex-grow"></div>
        <div className="">
          <a
            href="/"
            className="flex text-sm px-4 py-2 items-center justify-center leading-none border rounded text-white border-white hover:border-transparent hover:text-blue-800 hover:bg-white"
          >
            <svg
              xmlns="http://www.w3.org/2000/svg"
              class="h-6 w-6"
              fill="none"
              viewBox="0 0 24 24"
              stroke="currentColor"
            >
              <path
                stroke-linecap="round"
                stroke-linejoin="round"
                stroke-width="2"
                d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"
              />
            </svg>
            <div className="text-lg">Hovedside</div>
          </a>
        </div>
      </div>
    </nav>
  );
}

export default Navbar;
