import React from "react";

function scoreBoard(første, andre, tredje) {
  if (første) {
    return (
      <div>
        <div className="bg-gray-100 border-2 border-gray-400 text-black p-1 bg-opacity-80 rounded hover:opacity-100 hover:bg-white hover:text-lg">
          <p className="font-bold text-sm">Resultat:</p>
          <p className="text-sm">
            1. {første}
            <br></br>
            2. {andre}
            <br></br>
            3. {tredje}
          </p>
        </div>
      </div>
    );
  }
}

function Tile(name, date, første, andre, tredje) {
  return (
    <div className="flex ">
      <div className="w-80 h-80 opacity-50 rounded bg-gradient-to-r from-slate-800 text-white p-3 hover:opacity-95 ">
        <div className="inline-flex ">
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="h-6 w-6"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              stroke-width="3"
              stroke="Green"
              d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"
            />
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              stroke-width="2"
              stroke="Red"
              d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"
            />
          </svg>
          <div>&nbsp;{name}</div>
        </div>
        <div className="inline-flex">
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="h-6 w-6"
            fill="none"
            viewBox="0 0 24 24"
            stroke="Lightblue"
          >
            <path
              stroke-linecap="round"
              stroke-linejoin="round"
              stroke-width="2"
              d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"
            />
          </svg>
          <div className="">&nbsp;{date}</div>
        </div>
      </div>
      <div className="grid p-2">
        {scoreBoard(første, andre, tredje)}
        <div className="self-end p-1 ">
          <button className="inline-flex items-center justify-center bg-blue-800  hover:bg-blue-900 text-white font-bold p-3 rounded opacity-90 hover:opacity-100">
            <svg
              xmlns="http://www.w3.org/2000/svg"
              class="h-5 w-5"
              viewBox="0 0 20 20"
              fill="currentColor"
            >
              <path d="M11 3a1 1 0 100 2h2.586l-6.293 6.293a1 1 0 101.414 1.414L15 6.414V9a1 1 0 102 0V4a1 1 0 00-1-1h-5z" />
              <path d="M5 5a2 2 0 00-2 2v8a2 2 0 002 2h8a2 2 0 002-2v-3a1 1 0 10-2 0v3H5V7h3a1 1 0 000-2H5z" />
            </svg>
            Detaljer
          </button>
        </div>
      </div>
    </div>
  );
}

export default Tile;
